;**********************************************
; Test Matrix Switch 4x4 
; Hardware  : CP-PIC V3.0/4.0 
; OSC       : 10 MHz [ HS mode ]
; file name : key_4x4
; Assembler : mpasm.exe
; Programmer: Watcharin Kaolop
; Company   : ETT  CO.,LTD.
; Date      : 8/8/2002
;**********************************************
; STEP to follow when test this program
;    1.Connect RS232 or RS422 cable between board and PC.
;    2.Download this program to CPU.
;    3.Run terminal program such as Procom plus,XTALK etc.
;    4.Set parameter Procom plus to 9600 baud,No parity,8 bits data and 1 bit. stop
;    5.Connect Keyboard 4x4 to KBI/IO on board CP-PIC V4.0
;	RB4 connect  row     1
;	RB5 connect  row     2	
;	RB6 connect  row     3
;	RB7 connect  row     4
;	RD0 connect  column  1
;	RD1 connect  column  2
;	RD2 connect  column  3
;	RD3 connect  column  4
;    6.Press any key on keyboard, you will see the key that you pressed.
;**********************************************

     list p=16f877                 ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions

count     EQU       0x21
colm	  EQU	    0x22
dt1       EQU       0x23
dt2       EQU       0x24
dt3       EQU       0x25

          ORG       0x0000

;************ initial *******************

init      bsf       STATUS,RP0     ; select bank 1
	  clrf      TRISD
	  movlw	    0xff
	  movwf	    TRISB
	  bcf	    OPTION_REG,7	  
          movlw     0x40           ; BAUD rate 9600
          movwf     SPBRG
          clrf      TXSTA          ; 8 bits data ,no,1 stop

	  bcf       STATUS,RP0     ; select bank 0
          bsf       RCSTA,SPEN     ; Asynchronous serial port enable
          bsf       RCSTA,CREN     ; continuous receive

          bsf       STATUS,RP0     ; select bank 0
          bsf       TXSTA,TXEN     ; Transmit enable
          BSF	    TXSTA,BRGH	   ; HI SPEED
	  bcf       STATUS,RP0     ; select bank 0	  
;********** start to send **********************	 
scan	  movlw	    0xfe	   ; start scan column 1
	  movwf	    colm
	  clrf	    count	   ; clear counter
scan1	  movf	    colm,w	   ; scan column
	  movwf     PORTD
	  btfss	    PORTB,4	   ; check RB4
	  goto	    sw_1	   
	  btfss	    PORTB,5	   ; check RB5
	  goto	    sw_2
	  btfss	    PORTB,6	   ; check RB6
	  goto	    sw_3
	  btfss	    PORTB,7	   ; check RB7
	  goto	    sw_4
	  movlw	    .4
	  clrc			   ; clear carry flag
	  addwf     count,f        
	  clrc
	  rlf	    colm,f	   ; rotate scan
	  btfsc	    colm,4	   ; check last column
	  goto	    scan1
	  goto	    scan	   ; start scan
	  
sw_4	  incf	    count,f	   
sw_3	  incf	    count,f
sw_2	  incf	    count,f
sw_1	  movf	    count,w
	   
	  call      TAB
	  call	    send	   ; Send data to RS232
	  call	    delay
	  goto	    scan	   ; Back to scan

send      movwf     TXREG          ; Send recent data to TX 
wait1     movlw     TXSTA          ; 
	  movwf	    FSR
          btfss     INDF,1         ; check TRMT bit in TXSTA (FSR)
          goto      wait1          ; TXREG full  or TRMT = 0	  
	  return

delay     movlw	    3		   ; delay 
	  movwf	    dt1
sd3	  clrf      dt2
sd2       clrf      dt3
sd1       decfsz    dt3
          goto      sd1
          decfsz    dt2
          goto      sd2
	  decfsz    dt1
	  goto      sd3
          return

;********* Tebel of message ********************  

TAB       addwf     PCL,f           ; Move offset to PC lower

	  DT	 "0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"

        END
